# Biblical Law Literature in Its Ancient Near Eastern Context

## 古代近东的法律

许多古代近东法律法规**与特定国王相关联**。国王在这些法律收藏中似乎是皇家立法者，他们是法律的来源和正义的捍卫者。出于这个原因，我们将很快呈现的许多法律集都以国王的名字命名。但是，还有些其他收藏不属于特定的国王。我们通常会用它们的**来源地**来标记。

1. **Laws of Ur-Nammu**：这是最古老的法律法规。它是用苏美尔语书写，由公元前2100年左右的Ur-III王朝的创始人Ur-Nammu 的文士完成。
2. **Laws of Lipit-Ishtar**：这部法律代码也是在大约公元前1900年左右由 Isin 的国王 Lipit-Ishtar 的抄写员用苏美尔语写成。
3. **Laws of Eshnunna**：这个法典稍晚一点——它是在公元前1770年左右由阿卡德语书写的。该法律不属于特定的国王，它以它所写的城市命名。
4. **Code of Hammurabi**（汉谟拉比法典）：这是最着名的法律法规。它由汉谟拉比国王的宫廷官员用阿卡德语书写。该法典可能追溯到公元前 1750 年左右。汉谟拉比法典主要来自一个巨大的皇家石碑。石碑显示国王站在美索不达米亚太阳神沙玛什（也是司法之神）面前。
5. **Middle-Assyrian Laws**：这个系列是用阿卡德语写成的，可能是在公元前十四世纪创作的。
6. **Neo-Babylonian Laws**：这些阿卡巴人的法律是在新巴比伦时期组成的，似乎并不属于特定的国王。它们约在公元前700年左右。
7. **Hittite Laws**：这个法律来自美索不达米亚以外的赫梯王国。赫梯的居民并没有说闪米特语，他们使用赫梯语，并用一种用楔形文字书写赫梯语（一种印欧语言）。这一法律可能是在公元前16世纪组成的，然后反复复制到公元前12世纪。在圣经时期，赫梯人与以色列没有直接接触。然而，赫梯与圣经文化之间存在着几种惊人的亲密关系。这些关系主要体现在宗教文学和合同文学。

这些古代近东法律具有许多共同特征。它们的主题比较相似，都是集中在刑事和民事（criminal and civil）。每个法律的基本公式也是相同的：即使用 “**If .. then**” 模式。这种模式在圣经学者中被称为 “**casuistic**”。所有收藏品也不拘一格：没有一个系统地涵盖不同的法律领域。他们也提出了类似的规范和观点。

一些学者将法律法规视为皇室法院的先例集，并不是具有约束力。因为这些文件中反映的裁决有时与收藏中的法律相矛盾。也有说法是这些不过是学校的书写员文学目的的知识材料。

在圣经中，摩西提到的圣约（Book of the Covenant ）学者们通常认为它包含了摩西从“接近上帝”（出埃及记20:21）到离开西奈（出埃及记20：22-24：3）的所有律法。



## 美索不达米亚和圣经牛触法的相似处

圣经中的圣约中提到了如下的 Goring Ox Law：

> 1) 牛若触死男人或是女人，总要用石头打死那牛，却不可吃它的肉，牛的主人可算无罪。
>
> 2) 倘若那牛素来是触人的，有人报告了牛主，他竟不把牛拴着，以致把男人或是女人触死，就要用石头打死那牛，牛主也必治死。若罚他赎命的价银，他必照所罚的赎他的命。牛无论触了人的儿子或是女儿，必照这例办理。
>
> 3) 牛若触了奴仆或是婢女，必将银子三十谢克尔给他们的主人，也要用石头把牛打死。
>
> (Ex. 21:28-32) 

这两种牛在拉比文学中被称为 “innocent ox” 和 “warned ox”.  类似的法律可以在汉谟拉比法典找到。

> 250：如果牛在穿过大街时触死了一人，那么这个案子就无法提出索赔。
>
> 251：如果一个人的牛是 known gorer，且城市当局通知他这是一只 known gorer，但是他不消弱牛角或者控制它，那么这头牛触死一个 awilu 阶级的人，他需要付 30谢克尔的银子。
>
> 252：如果被撞死是奴隶，则只要赔付 20谢克尔。

可以看到上述三对法律是一一对应的，无辜的，被警告的，针对奴隶的被警告的三种情况。“无辜的”和“被警告的”牛之间的区别是一种独特的法律原则，在其他法律体系中是未知的。因此，这是将两套法律联系起来另一个特征。

圣经里还有如下的描述：

> 这人的牛若伤了那人的牛，以致于死，他们要卖了活牛，平分价值，也要平分死牛。
>
>  (Exod 21:35) 

在 Eshnunna 的法律中，有与此法律完全平行的这条：

> （53）如果一头牛触死了另一头牛并因此导致它死亡，那么两头牛的所有者应将平分活牛的价值和死牛的尸体。

这两条法律非常相似。他们都提出了一个特殊的原始法律惯例：所有者分享剩余牛的价值和死牛的尸体。该惯例没有考虑到牛可能具有不同值的事实。

一些学者认为，这里涉及到圣经对美索不达米亚文本的文学依赖。其他人认为我们正在处理一个共同的古代近东传统，独立地反映在不同的来源。但这两种观点都没有足够的数据支持。我们无法指出文化接触的确切时间和地点。



## 美索不达米亚和圣经牛触法的区别

1. 对于被警告的牛，圣经和汉谟拉比法典都认为，所有者应该受到惩罚，因为他没有采取预防措施。然而，**惩罚的表现方式不同**。汉谟拉比法典只需要30谢克尔的银子。而圣经中的处理比较复杂：先要把牛给砸死，而主人也要偿命。如果受害方需要赎金代替偿命，那么他想要多少要多少。
2. 圣经强调触死人的牛需要被砸死，且不可被食用。
3. 第三个有趣的差异出现在**受害者的身份**上。在汉谟拉比法典中，他是一个 awilu 阶级的人，这并没有被进一步澄清。但在圣经中是不管男女（除了奴隶以外）。



## 牛触法和格林伯格的理论

20世纪80年代，==格林伯格==（Moshe Greenberg）发表了几篇非常有影响力的关于圣经法律的文章。在他的研究中，格林伯格认为以色列圣经法和美索不达米亚法之间存在本质区别。在美索不达米亚，国王是立法权威，在圣经中则是上帝。格林伯格认为，这种基本差异具有重要意义。

> ......据说以色列国王没有撰写法律代码......圣经所知道的唯一立法者就是上帝......整个规范领域，无论是法律还是道德，都只与上帝有关.......所有法律的神圣作者都是犯罪，违反上帝的意志......上帝直接作为立法者和主权者参与其中。
>
> (M. Greenberg, "Some postulates of biblical criminal law")

格林伯格认为，圣经法律的神圣来源定义了它的严格程度。他认为在牛触法中的死刑反映了圣经对把夺走生命视为“绝对错误”的态度。因此，对夺取他人生命的人的唯一合适的惩罚是死亡。

当我们审视圣经系统作为一个整体时，它基本上不允许赎金，因为它将杀戮视为“绝对错误”，指向上帝——法律的来源。

格林伯格的这一论点得到另一位圣经学者芬克尔斯坦（Jacob Finkelstein）的支持。芬克尔斯坦注意到，圣经将所讨论的赎金定义为“他生命的救赎”。这意味着赎金赎回了他 - 所有者 - 被判处死刑。这不是对受害者死亡的经济补偿。所以赎金的对象是拥有者而非受害者。格林伯格将要用这一原则解释其他差异。

在圣经中的触人牛需要被砸死，而在美索不达米亚法律中则不需要如此。格林伯格认为这种分歧来自于圣经对杀人罪的独特理解。

在圣经法律中之所以强调女人以及儿子女儿也适合这一法律其实是强调和美索不达米亚法律的“==代替惩罚==”（vicarious punishment）不同。代替惩罚是指一种报复，这在美索不达米亚法律中是众所周知的。格林伯格在这里主要声称圣经强调“未成年人应按照同样的规则处理”实际上是针对特定类型的美索不达米亚刑罚制度的论战。

> 事实上，这种个人责任原则支配着所有圣经法律。与近东其他地区的刑法相比，圣经的刑法在任何地方都没有集体或使用代理的惩罚世俗罪行。谋杀，疏忽杀人，诱惑等等，只会根据实际让罪魁祸首受到惩罚。



## 对于格林伯格的批判

一些研究人员批评格林伯格声称圣经法律将谋杀视为对上帝的犯罪，而不是针对受害者家庭的犯罪。他们声称这个想法与圣经“**血液复仇者**”（blood avenge）的概念是不相容的。血液复仇者多次出现在圣经中的凶杀案中。在某些圣经背景下，受害者的家属有权对凶手判处死刑。

> 这表明圣经法律将谋杀 - 至少在某种程度上 - 视为凶手与受害者家庭之间的私事。

格林伯格还声称美索不达米亚法律从不认为谋杀是**对神的罪**。这个论点也有争议。一些学者声称格林伯格的数据库太有限，他不仅应该包括法律条文，还应该包括美索不达米亚的宗教文本。例如他们赞美神的赞美诗经常将诸如抢劫，谋杀和通奸等刑事犯罪视为对上帝的违法行为。

## 一个公平的评定

> 在某些情况下，圣经有一种似乎反映与美索不达米亚法律不同法律观点的方式。但这种现象有多广泛？是否涵盖整个圣经的法律体系？

一位古代近东法律的领导学者雷蒙德·==威斯布鲁克==（Raymond Westbrook）给出了这个问题的答案。他证明了古代近东包括以色列拥有共同的法律遗产。威斯布鲁克发现了很多这样的例子，包括我们所知道的所有古代近东法律传统所共有的许多法律原则。

> 1)  关于受伤人员获得医疗赔偿的权利的法律，在圣经、汉谟拉比法典和赫梯法律都有所体现。
>
> 2) 有关遭受伤害导致流产的孕妇的法律，则出现在 Lipit-Ishtar 法律、汉谟拉比法典、中亚述法律和赫梯法律中。
>
> 3) 在关于强奸未婚少女中，区分为城市和乡村案件，这在圣经和赫梯法律中都有体现。


威斯布鲁克的研究结果多种多样，细节丰富。它们表明**以色列人和其他古代近东法律制度的共同特征超过了他们之间的差异**。

根据这些数据，将圣经法律描述为一种与周围文化根本不同的独特体系是错误的。以色列法律体系，包括其哲学和细节，通常属于全球古代近东传统。只有在这种理解的基础上，我们现在才能解决格林伯格和其他人所确定的独特特征。

在格林伯格提到的所有显着特征中，最引人注目的特征似乎与法律起源的关联点有关。在这里，格林伯格的洞察力令人大开眼界：圣经反复强调法律的唯一来源是上帝，而不是任何以色列国王。

圣经学者 ==Moshe Weinfeld== 认为以色列法律不是一个皇家法令，而在古代近东地区是一个神圣的命令。这一观点和 格林伯格类似。



## 圣经里的案例法和绝然法

1934年德国圣经学者 ==Albrecht Alt== 发表了一篇有关圣经法律的有影响力的文章。在他的文章中，Alt区分了圣经中的两种法律模式。他将这些模式标记为“==casuistic==”和“==apodictic==”。

“Casuistic Law” 也称为案例法（Case Law），它有如下特点：

1. It introduces **cases** and sub-cases.
2. It focuses on the **small detail** of each legal case.
3. It uses an “**if (when)… then …**” formula.

圣经有如下的例子：

> When a man sells his daughter as a slave, she shall not go out as the male slaves do. (Exod 21:7) 
>
> 人若卖女儿作婢女，婢女不可像男仆那样出去。



绝然法（apodictic law）的格式是直接的戒律。比如：

> You shall not permit a sorceress to live! (Exod 22:18)
>
> 行邪术的女人，不可容她存活。 

绝然法和案例法相比有不同的态度：它是简短而果断的，没有子条款。根据Alt，这种简洁的风格反映了它的确定性。更重要的是，案例法通常涉及<u>非宗教问题</u>。圣经的案例法往往涵盖刑法和民法，典型主题包括奴隶制、财产和资本案件等。绝然法则侧重于**宗教事务**。绝然法最好的例子是十诫（Ten Commencements）。它包含一个明确的命令，并且不对任何详细或冗长的具体案例进行讨论。

## 案例法和绝然法的对比

Alt 在检查了古代近东法律时发现它们基本都是案例法。美索不达米亚的法律制度主要基于案例法。Alt的结论是，在圣经中，casuistic和apodictic模式来自两个独立的来源。 案例法是一种古老的近东遗产。相比之下，Apodictic法则是以色列人的创新。

这一结论同样也想格林伯格的理论一样收到了不少人的批评。他们反对在以色列以外不知道apodictic法律的想法。一些学者认为Alt的数据库太有限了。

因为在古代近东文化的其他体裁文献中，有这种 apodictic 模式。

> In the case of Alt, his opponents maintain that while legal literature from the ancient Near East does not employ the apodictic pattern, it occurs extensively <u>in other genres</u>. 

一些学者认为，圣经的apodictic模式是从一种普遍存在的命令的类型中借用的。没有办法证明或否定这一假设。无论如何，即使这种法律起源于圣经之外，它在圣经中作为一种法律形式的采用似乎也很重要。它符合圣经的倾向，即将上帝作为律法的来源，并反映出圣经的观念，即律法是上帝强加的直接义务。但是这些独特点不应该掩盖这样一个事实，即圣经法律是古代近东遗产的一个组成部分。

## 撒拉和夏甲的案例

随着汉谟拉比法典的发现，学者们注意到撒拉和夏甲（Hagar）的故事与汉姆拉比法律第146号案例有着紧密的联系：

> If a man marries a nadītu, and she gives a slave woman to her husband, and she (the slave) then bears children, after which that slave woman aspires to equal status with her mistress—because she bore children, her mistress <u>will not sell her</u>; she shall <u>place upon her the slave-hairlock</u>, and she shall <u>reckon her with the slave women</u>. (Code of Hammurabi, 146)

在圣经故事（创世纪第16章）里，Sarai 严厉地对待夏甲，并导致了夏甲的逃脱。这部法律处理的案件与萨拉和夏甲非常相似。美索不达米亚法律详述了妻子的权利和义务：她不能卖掉奴隶女孩，因为她已经为丈夫提供了后代。然而，她可以通过公认的社会习俗来强调她的地位：她可以把奴隶女孩剪成奴隶式头发，并把她算作“奴隶女人”。

这一法律和撒拉夏甲的故事的关系，让一些学者认为他可能给撒拉的行为提供了理由。她对夏甲的严厉对待可能暗示了一种故意形式的羞辱，旨在将夏甲置于她的适当位置。

汉谟拉比法146与萨拉和夏甲的故事只能说部分相似，因为在汉谟拉比法律并不是指任何女性，而是指naditu。 naditus是居住在父权制家庭之外的**女祭司**。也就是说，

类似更多的例子出现在古亚述时代的结婚合同中。在实际一名叫 Hatala 女士的一份合同中，它指出，如果她在婚礼后两年内不生育，她就可以给她的丈夫一个奴隶女孩。或者说，丈夫允许带一个奴隶女孩，而妻子可以挑选和购买特定的奴隶女孩。这两种解读反应两种不同的社会观念。

一种假设奴隶女孩是属于妻子的资产，而另一种属于丈夫。这两种观点都反映在资料中。汉谟拉比法典146认为这是妻子的资产。这是因为作为一名女祭司（naditu），<u>她不能拥有自己的孩子</u>。这种情况下的孩子被认为是她的孩子。在圣经的故事中，莎拉表达了同样的观点：“我可能会得到她的孩子。”这个社会概念也反映在创世纪第30章中雅各家庭的故事中。瑞秋（Rachel）和利亚（Leah）将他们的仆人交给雅各。而出生的儿子被认为是他们的。

然而，在其他来源中（a contract from the city of Nuzi），将奴隶女孩视为丈夫的资产。与奴隶女孩结婚的选择在于丈夫的手中。因此，丈夫保护他的后代权利。

在这里，不孕的妻子必须向丈夫提供另一个女人：这符合丈夫的利益。另一个女人的后代也受到保护：妻子不能把他们赶走。从圣经的角度来看，这个细节很重要。在我们之前读过的关于莎拉和夏甲的故事（创世纪16章）中，由于莎拉对她的严厉对待，夏甲逃跑了。然而，在后来的故事中，在创世纪21章中，夏拉被撒拉驱逐。

> And she said to Abraham, “Cast out this slave woman with her son, for the son of this slave woman shall not share in the inheritance with my son Isaac.” 
> (Gen 21:10)  

我们也看到，美索不达米亚的来源在他们对情妇的行为的判断上有所不同。没有一个流行的规则来管理女主人是否被允许严重对待奴隶或是否可以驱逐她的后代。这些社会习俗的态度因时间，地点和环境而异。甚至对获得奴隶女孩是否代表妻子或丈夫利益的问题的处理也各不相同。

## 父权社会制度

这些学者试图利用美索不达米亚的资料来说明圣经的故事，但也证明了它的历史性。如果**父权制故事**在公元前2000年的社会习俗中找到了具体的相似之处，这意味着它们是真实的：它们反映了许多学者对公元前第二个千年的父系（patriarchs）时代的现实。

来自 Nuzi 的文件在这一方面尤为重要。古代近东学者 ==Cyrus Gordon== 认为，在 Nuzi 发现的法律文本和父权制故事有很多相似之处。比如在创世纪 15:3 中，亚伯拉罕宣称如果上帝不给他后代，他的管家就将会是他的继承人。两一个发展这一理论的著名学者是 Ephraim Avigdor Speiser。

反对戈登观点的圣经学者约翰·凡·塞特斯（ ==John Van Seters==）表明，这个问题的答案是否定的。 他确定了莎拉的故事相似之处来自后期的法律文本。公元前17世纪的中亚述的结婚合同如下表明妻子有卖掉奴隶女孩的权力。但历史讨论的重点是，这种习俗不仅限于公元前第二个千年。塞特斯得出结论，父权制叙事是在**公元前一千年**期间创作的。

然而，从法律资源中得出历史结论（标定时间）的愿望似乎是相当牵强的。我们所拥有的是来自不同时期的各种文本，为我们提供了理解Sarah-Hagar关系的社会和法律背景。这些消息来源指向整个古代近东地区的一种习俗，根据这种习俗，一个无法生育孩子的妻子可以将一个奴隶女孩送给她的丈夫。



whzecomjm
20190623